<?php

declare(strict_types=1);

namespace apexl\Io\modules\cron\Command;

use apexl\Io\modules\cron\Action\RunCron;
use app\vendor\apexl\io\src\Io\modules\system\commands\DaedalusCommand;
use DI\Container;
use Symfony\Component\Console\Attribute\AsCommand;
use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;
use Throwable;

#[AsCommand(name: 'cron:run', description: 'Run cron tasks')]
class RunCronTasksCommand extends DaedalusCommand
{
    public function __construct(
        private readonly Container $container,
        private readonly RunCron $runCron,
        ?string $name = null
    ) {
        parent::__construct($name);
    }

    /**
     * @throws Throwable
     */
    protected function execute(InputInterface $input, OutputInterface $output): int
    {
        $this->container->call($this->runCron->run(...));

        return Command::SUCCESS;
    }
}
