# IO Cron

## Cron-runner for the IO framework, wrapping the Symfony Scheduler package

## Usage

- This module adds a Daedalus command `daedalus cron:run` to execute the cron jobs. This can be run manually but ideally
  a `systemd` service or similar should be created to manage this. An example `systemd` service is included in the root
  of the module.

## Registering tasks

Cron jobs should be registered using the IO HOOK system, hooking onto the
`\apexl\Io\modules\cron\cronModule::HOOK__REGISTER_CRON_TASK`.

This hook will be passed an Collection of Schedules. New Schedules should be added to this collection, and the
collection returned. Schedules should be keyed with the class of the Action that they are running

Actions MUST implement the `apexl\Io\modules\cron\Interface\CronAction` interface, which requires a single `run()`
method.

## Statefulness

Schedules can be made 'stateful'. This means that if the `cron:run` service is not running at the time they are
scheduled. They will be run immediately, the next time the Cron process is started.

The `->stateful()` method requires a cache implementing `Symfony\Contracts\Cache\CacheInterface`. This module includes
an implementation of this that uses IO's System variables to store data: `apexl\Io\modules\cron\Service\SchedulerCache`.

This can be used in combination with `->processOnlyLastMissedRun(true)`, which ensures that only one missed instance of
each schedule is run, if many have been missed.

## Example

```
final readonly class MyCronAction implements CronAction
{
    public function run(): void
    {
        // Do something
    }
}


final readonly class RegisterMyCronJobHook implements AbstractHook
{
    public function __construct(private SchedulerCache $schedulerCache) {}

    static protected function hooks(): array
    {
        return [cronModule::HOOK__REGISTER_CRON_TASK];
    }

    public function __invoke(ScheduleCollection $schedules): Arrayy
    {
        $schedules->add(
            (new Schedule())
                ->with(RecurringMessage::cron('@monthly', new MyCronAction()))
                ->stateful($this->schedulerCache)
                ->processOnlyLastMissedRun(true),
                
            MyCronAction::class
        );

        return $schedules;
    }
}

```