<?php

namespace apexl\Io\modules\display\components;

use apexl\Io\includes\Routes;
use apexl\Io\modules\component\entities\componentEntity;

class Modal extends componentEntity
{
    public function __construct()
    {
        parent::__construct();
        $this->addClass('button-link');
    }

    public function setTitle($title)
    {
        $this->addProperty('title', $title);
        return $this;
    }

    public function setModalId($modalId)
    {
        $this->addProperty('modalId', $modalId);
        return $this;
    }

    public function setButtonContent($content)
    {
        $this->addProperty('buttonContent', $content);
        return $this;
    }

    public function setButtonClass($class)
    {
        $this->addProperty('buttonClass', $class);
        return $this;
    }

    public function setContentSrc($src, $data=[])
    {
        $this->addProperty('contentSrc', Routes::getRoutePattern($src, $data, false));
        return $this;
    }

    public function setRowConditional($if)
    {
        $this->addProperty('if', $if);
        return $this;
    }
}
