<?php
namespace apexl\Io\modules\display\components;

use apexl\Io\modules\component\entities\componentEntity;

class ProgressBar extends componentEntity {
    public function __construct()
    {
        parent::__construct();
        $this->activeStage(0);
        $this->addStages( ['Start', 'Middle', 'End']);
        $this->showLabels(true);
    }

    public function addStages(array $stages){
        $this->addProperty('stages', $stages);
        return $this;
    }

    public function activeStage(int $activeStage){
        $this->addProperty('activeStage', $activeStage);
        return $this;
    }

    public function showLabels(bool $showLabels){
        $this->addProperty('showLabels', $showLabels);
        return $this;
    }
}