<?php

namespace apexl\Io\modules\display\components;

use apexl\Io\modules\component\entities\componentEntity;

class TableButton extends componentEntity
{
    public function __construct()
    {
        parent::__construct();
        $this->addRoute('/');
        $this->addText('');
    }

    public function addRoute($route)
    {
        $this->addProperty('route', $route);
        return $this;
    }

    public function addText($text)
    {
        $this->addProperty('text', $text);
        return $this;
    }

    public function addIcon($icon)
    {
        $this->addProperty('icon', $icon);
        return $this;
    }

    public function disabled($disabled = false)
    {
        $this->addProperty('disabled', $disabled);
        return $this;
    }

    public function addEvent($event)
    {
        $this->addProperty('event', $event);
        return $this;
    }

    public function isPost()
    {
        $this->verb = 'post';
        return $this;
    }

    public function openInNewWindow()
    {
        $this->addTarget('_blank');
    }

    protected function addTarget($target)
    {
        $this->addProperty('target', $target);
        return $this;
    }
}
