<?php

namespace apexl\Io\modules\display\components;

use apexl\Io\modules\component\entities\componentEntity;

class DisplayTable extends componentEntity
{
    protected $displayData;

    public function __construct()
    {
        parent::__construct();
    }

    public function addTitle($title)
    {
        $this->addProperty('title', $title);
        return $this;
    }

    public function addData($title, $data = null, $component = null)
    {
        $display = [];
        $display['title'] = $title;
        if ($data) {
            $display['content'] = $data;
        }
        if ($component) {
            $display['component'] = (string)$component;
        }
        $this->displayData[] = (object)$display;
        $this->addProperty('data', $this->displayData);
        return $this;
    }

    public function addRows($rows)
    {
        foreach ($rows as $row) {
            $this->addData($row[0]??'', $row[1]??'');
        }

        return $this;
    }
}
