<?php

namespace apexl\Io\modules\display\components;

use apexl\Io\includes\Entity;
use apexl\Io\includes\Routes;

class CardEntityFilteredDisplayTable extends EntityFilteredDisplayTable
{

    public function __construct(Entity $entity = null, $replacements = [], $withButtons = true, $buttonFormat='buttons')
    {
        parent::__construct($entity, $replacements, $withButtons, $buttonFormat);
        $this->setName('CardDataTable');
        $this->addProperty('supportComponentLocation', 'header');
    }

    public function addTitle($title)
    {
        $this->addProperty('title', $title);
        return $this;
    }

    public function setSupportComponentLocation($location)
    {
        if (in_array($location, ['header', 'body'])) {
            $this->addProperty('supportComponentLocation', $location);
        }
        return $this;
    }

}
