<?php

namespace apexl\Io\modules\display\components;

use apexl\Io\modules\component\entities\componentEntity;

class LinkTile extends componentEntity
{
    public function __construct()
    {
        parent::__construct();
        $this->setColWidth('sm', 3);
        $this->setColWidth('md', 2);
        $this->addRoute('/');
        $this->addText('');
        $this->addIcon('link');
    }

    public function addRoute($route)
    {
        $this->addProperty('route', $route);
        return $this;
    }

    public function addText($text)
    {
        $this->addProperty('text', $text);
        return $this;
    }

    public function addIcon($icon)
    {
        $this->addProperty('icon', $icon);
        return $this;
    }

    public function isExternal($external = true)
    {
        $this->addProperty('external', $external);
        return $this;
    }

    public function addTarget($target)
    {
        $this->addProperty('target', $target);
        return $this;
    }
}
