<?php

namespace apexl\Io\modules\display\components;

use apexl\Io\includes\Routes;
use apexl\Io\modules\component\entities\componentEntity;

class AccountTile extends componentEntity
{
    public function __construct()
    {
        parent::__construct();

        $this->addProperty('logoutUrl', Routes::getRoutePattern('user.logout'));
    }

    /**
     * @param $imgSrc
     * @return $this
     */
    public function src($imgSrc)
    {
        $this->addProperty('imgSrc', $imgSrc);
        return $this;
    }

    /**
     * @param $name
     * @return $this
     */
    public function name($name)
    {
        $this->addProperty('name', $name);
        return $this;
    }

    /**
     * @param $role
     * @return $this
     */
    public function role($role)
    {
        $this->addProperty('role', $role);
        return $this;
    }
}
