<?php
namespace apexl\Io\modules\display\components;

use apexl\Io\modules\component\entities\componentEntity;

class Chart extends componentEntity {

    protected $chartData = [];
    protected $colours;
    protected $chartType;

    public function __construct()
    {
        parent::__construct();
        $this->setChartType('LineChart');
        $this->colours = $this->generateRandomColoursArray(10);
    }

    public function setTitle($title)
    {
        $this->addProperty('title', $title);
        return $this;
    }

    public function setChartType($type){
        $this->addProperty('chartType', $type);
        $this->chartType = $type;
        return $this;
    }

    public function addDataset($data, $label=null)
    {
        switch ($this->chartType) {
            case 'PieChart':
                $this->chartData[] = (object)[
                    'data' => $data,
                    'backgroundColor' => $this->generateRandomColoursArray(count($data)),
                ];
                break;
            default:
                $this->chartData[] = (object)[
                    'data' => $data,
                    'backgroundColor' => $this->colours[count($this->chartData)],
                    'borderColor' => $this->colours[count($this->chartData)],
                    'label' => $label,
                ];
            break;
        }
        $this->setChartData($this->chartData);
        return $this;
    }

    public function setChartData($data){
        $this->addProperty('chartData', $data);
        return $this;
    }

    public function setChartLabels($labels, $generateRandomColours=true) {
        $this->addProperty('chartLabels', $labels);
        if ($generateRandomColours) {
            $this->setChartColours($this->generateRandomColoursArray(count($labels)));
        }
        return $this;
    }

    public function setChartColours($colours) {
        $this->addProperty('chartColours', $colours);
        return $this;
    }

    protected function generateRandomColoursArray($length)
    {
        $colours = [];
        for ($i=0; $i<$length; $i++) {
            $colours[] = sprintf('#%06X', mt_rand(0, 0xFFFFFF));
        }

        return $colours;
    }
}