<?php

namespace apexl\Io\modules\display\components;

use apexl\Io\modules\component\entities\componentEntity;

class Offcanvas extends componentEntity
{
    public function __construct()
    {
        parent::__construct();
        $this->addClass('button-link');
    }

    public function addTitle($title)
    {
        $this->addProperty('title', $title);
        return $this;
    }

    public function addPlacement($placement)
    {
        $this->addProperty('placement', $placement);
        return $this;
    }

    public function addIcon($icon)
    {
        $this->addProperty('icon', 'fa-'.$icon);
        return $this;
    }

    public function addOffcanvasClass($class)
    {
        $this->addProperty('offcanvasClass', $class);
        return $this;
    }

    public function addCloseButtonClass($class)
    {
        $this->addProperty('closeButtonClass', $class);
        return $this;
    }


}
