<?php

namespace apexl\Io\modules\display\components;

use apexl\Io\includes\Entity;
use apexl\Io\includes\Routes;
use apexl\Io\modules\component\entities\componentEntity;
use apexl\Io\modules\formbuilder\includes\inputField;

class ButtonBar extends componentEntity
{
    protected $row;
    protected $linkParams = [];

    public function __construct(Entity $entity = null)
    {
        parent::__construct();
        $this->addClass('button-link');

        $this->colWrapper = (new ColWrapper());
        $this->rowWrapper = (new RowWrapper())->addComponent($this->colWrapper);
        $this->addComponent($this->rowWrapper);
    }

    public function setEntity(Entity $entity, $pageType='View'): ButtonBar
    {
        $this->entity = $entity;
        if ($entity->{$entity->primaryKey}) {
            $this->addLinkParam($entity->primaryKey, $entity->{$entity->primaryKey});
        }
        switch ($pageType) {
            case 'List':
                $this->listViewPageButtons();
                break;
            case 'View':
                $this->addViewPageButtons();
                break;
            case 'Edit':
                $this->addEditPageButtons();
                break;
            case 'Create':
                $this->addCreatePageButtons();
                break;
        }
        return $this;
    }


    public function addRoute($route): ButtonBar
    {
        $this->addProperty('route', $route);
        return $this;
    }

    public function addText($text): ButtonBar
    {
        $this->addProperty('text', $text);
        return $this;
    }

    public function addLinkParam(string $name, string $value)
    {
        $this->linkParams[$name] = $value;
    }

    public function listViewPageButtons(): ButtonBar
    {
        $create = $this->entity->getEntityName() . '.display.post';
        $this->addCreateButton($create);
        return $this;
    }

    public function addViewPageButtons(): ButtonBar
    {
        $viewAll = $this->entity->getEntityName() . '.display.all';
        $edit = $this->entity->getEntityName() . '.display.put';
        $delete = $this->entity->getEntityName() . '.display.delete';
        $this->addViewAllButton($viewAll);
        $this->addEditButton($edit);
        $this->addDeleteButton($delete);
        return $this;
    }

    public function addEditPageButtons(): ButtonBar
    {
        $viewAll = $this->entity->getEntityName() . '.display.all';
        $view = $this->entity->getEntityName() . '.display.get';
        $delete = $this->entity->getEntityName() . '.display.delete';
        $this->addViewButton($view);
        $this->addViewAllButton($viewAll);
        $this->addDeleteButton($delete);
        return $this;
    }

    public function addCreatePageButtons(): ButtonBar
    {
        $viewAll = $this->entity->getEntityName() . '.display.all';
        $this->addViewAllButton($viewAll);
        return $this;
    }

    /**
     * @param $routeName
     * @return $this
     */
    public function addViewButton($routeName): ButtonBar
    {
        $this->addButton($routeName, 'View', 'eye', $this->getAccessFromRoute($routeName));
        return $this;
    }

    /**
     * @param $routeName
     * @return $this
     */
    public function addViewAllButton($routeName): ButtonBar
    {
        $this->addButton($routeName, 'View All', 'list', $this->getAccessFromRoute($routeName));
        return $this;
    }

    /**
     * @param $routeName
     * @return $this
     */
    public function addCreateButton($routeName): ButtonBar
    {
        $this->addButton($routeName, 'Create', 'plus', $this->getAccessFromRoute($routeName));
        return $this;
    }

    /**
     * @param $routeName
     * @return $this
     */
    public function addEditButton($routeName): ButtonBar
    {
        $this->addButton($routeName, 'Edit', 'edit', $this->getAccessFromRoute($routeName));
        return $this;
    }

    /**
     * @param $routeName
     * @return $this
     */
    public function addDeleteButton($routeName): ButtonBar
    {
        $this->addButton($routeName, 'Delete', 'trash', $this->getAccessFromRoute($routeName), true);
        return $this;
    }

    /**
     * @param $routeName
     * @param string $icon
     * @param false $disabled
     * @return $this
     */
    public function addButton($routeName, string $buttonText='', string $icon ='', bool $disabled = false, bool $danger = false, string $asynch = null): ButtonBar
    {
        $button = (new SimpleButton())
            ->addRoute(Routes::getRoutePattern($routeName, $this->linkParams, false))
            ->addText($buttonText);
        if ($icon !== '' && $icon !== '0') {
            $button->addProperty('icon', $icon);
        }
        if ($danger) {
            $button->addClass('btn btn-danger mx-2');
        } else {
            $button->addClass('btn mx-2 bg-transparent');
        }

        if ($disabled) {
            $button->addRoute('#');
            $button->addClass('btn-disabled');
            $button->disabled($disabled);
        }
        if ($asynch && in_array($asynch, ['GET','POST','PUT','DELETE'])) {
            $button->addProperty('asynch', $asynch);
        }
        $this->colWrapper->addComponent($button);
        return $this;
    }

    public function addForm(string $formId, string $routeName, $args)
    {
        $this->colWrapper->addComponent(
            (new FormComponent())->setID('SIMRefresh')->src(
                Routes::getRoutePattern('simcardDisplay.form.sims.refresh', $args)
            )
        );
    }

    public function addCallbackButton(string $name, string $routeName, $params)
    {
        //$this->colWrapper->addComponent(
        // (new inputField($name, 'button'))->setLabel(null)->setCallback(Routes::getRoutePattern($routeName, $params), 'put')->setValue(true)->addClass('btn mx-2 bg-transparent')
        //);
    }

    /**
     * @param $routeName
     * @return bool
     */
    public function getAccessFromRoute($routeName): bool
    {
        $route = Routes::getRoute($routeName);
        if (($route ?? false) && $permission = $route->getArgs('permission')) {
            //we need to pass the opposite here as disabled is false if access it true.
            return !$this->currentUser->isAllowed($permission);
        }
        //no permission? just return true.
        return (bool) $route; //no route? return false.
    }
}
