<?php

namespace apexl\Io\modules\display\services;

use apexl\ClassEngine\EngineSingleton;

/**
 * Class Render
 * Provides a global render store for pages.
 * Allows various projects to manipulate the default display output of modules
 * @package apexl\Io\modules\page\services
 */
class Render extends EngineSingleton
{
    protected static $pages = [];
    protected static $activePage = "default";

    protected function __construct()
    {
        parent::__construct();
    }

    public static function setActive($activePage)
    {
        self::$activePage = $activePage;
    }

    public static function registerDefault($page)
    {
        self::$pages["default"] = $page;
    }

    public static function registerPage($name, $page)
    {
        self::$pages[$name] = $page;
    }

    public static function getPage($name)
    {
        return self::$pages[$name] ?? false;
    }

    //add content and render.
    public static function content($components, $page = "default")
    {
        return self::$pages[$page]->addToContent($components);
    }

    public static function setPageTitle($title, $page = "default")
    {
        return self::$pages[$page]->setPageTitle($title);
    }

    public static function setMetaTitle($title, $page = "default")
    {
        return self::$pages[$page]->setMetaTitle($title);
    }

    public static function setMetaDescription($desc, $page = "default")
    {
        return self::$pages[$page]->setMetaDescription($desc);
    }

    /**
     * @param null $components
     * @return array
     */
    public static function build($components = null)
    {
        if ($components) {
            self::$pages[self::$activePage]->addToContent($components);
        }
        return isset(self::$pages[self::$activePage]) ? self::$pages[self::$activePage]->getPage() : [];
    }
}
