<?php

namespace apexl\Io\modules\display\components;

use apexl\Io\modules\component\entities\componentEntity;
use apexl\Io\modules\menu\services\Menu as MenuService;

class Menu extends componentEntity
{
    public function __construct(MenuService $menu = null)
    {
        parent::__construct();
        if ($menu !== null) {
            $this->addMenuItems($menu->getAllItemsAsMenu($this->currentUser));
        }
    }

    public function title($menuTitle)
    {
        $this->addProperty('title', $menuTitle);
        return $this;
    }

    public function addMenuItems($menuItems)
    {
        $this->addProperty('menuItems', $menuItems);
        return $this;
    }
}
