<?php

namespace apexl\Io\modules\display\pages;

use apexl\Io\includes\System;
use apexl\Io\modules\display\components\ImageTile;
use apexl\Io\modules\display\includes\Page;
use apexl\Io\modules\display\regions\NoUIContentRegion;
use apexl\Io\modules\display\regions\PageContentRegion;

/**
 * Class blankPage
 * A blank page with no UI, only a content region.
 * @package apexl\Io\modules\display\pages
 */
class blankPage extends Page
{
    protected function buildRegions()
    {
        $this->globalRegion = (new PageContentRegion())->addWrapperClass(System::getVariable('noui_page_global_classes') ?? 'h-100');
        $this->globalRegion->addRegions([
            new NoUIContentRegion([
                (new ImageTile())->src(System::getVariable('noui_page_logo_url') ?? '/assets/logos/logo.svg')
            ])
        ]);
    }

    /**
     * @param $component
     * @param null $weight
     */
    public function addToContent($component, $weight = null)
    {
        $this->addToRegion($component, NoUIContentRegion::class, $weight);
        return $this;
    }
}
