<?php

namespace apexl\Io\modules\display\pages;

use apexl\Io\includes\Hook;
use apexl\Io\includes\System;
use apexl\Io\modules\display\components\AccountTile;
use apexl\Io\modules\display\components\DropdownMenu;
use apexl\Io\modules\display\components\HorizontalMenu;
use apexl\Io\modules\display\components\ImageTile;
use apexl\Io\modules\display\components\Menu as MenuComponent;
use apexl\Io\modules\display\components\RowWrapper;
use apexl\Io\modules\display\components\TitleTile;
use apexl\Io\modules\display\includes\Page;
use apexl\Io\modules\display\regions\AdminMenuRegion;
use apexl\Io\modules\display\regions\ContentRegion;
use apexl\Io\modules\display\regions\LeftSideBarRegion;
use apexl\Io\modules\display\regions\PageContentRegion;
use apexl\Io\modules\display\regions\TopBarRegion;
use apexl\Io\modules\user\entities\roleEntity;

class genericPageLeftMenu extends Page
{
    public const HOOK__MENUS = 'genericPageLeftMenu.menus';

    /**
     * @param $component
     * @param  null  $weight
     */
    public function addToTopBar($component, $weight = null)
    {
        $this->addToRegion($component, "TopBarRegion", $weight);
    }

    /**
     * @param $component
     * @param  null  $weight
     */
    public function addToLeftSidebar($component, $weight = null)
    {
        $this->addToRegion($component, "LeftSideBarRegion", $weight);
    }

    /**
     * build the wrapper, specify some default "regions" that can be populated with components.
     *
     * Page structure by default looks like this:
     *  The page content
     *  |------------------------------------------------
     *  | The Top Menu bar
     *  | - Image region -- Menu region --
     *  |------------------------------------------------
     *  | - The Left Sidebar -- | Main content area
     *  |                       | Title Tile
     *  |                       | Main content
     *  | -----------------------------------------------
     *  | - The footer
     *  | -----------------------------------------------
     * @throws \Exception
     */
    protected function buildRegions()
    {
        $this->TitleTile = new TitleTile($this);

        $this->registerTitleComponent((new TitleTile($this))->addBreadcrumbs($this->menu->getMenu()));
        //reset the regions, we have only content as a default.
        $this->globalRegion = (new PageContentRegion())->addWrapperClass('page-left-menu row m-0');
        $roleEntity = new roleEntity();
        if ($rid = $this->currentUser->roles[0] ?? null) {
            $roleEntity->load($rid);
        }
        if ($this->currentUser->isAllowed('administer') && (System::getVariable('core_display_admin_menu') ?? true)) {
            $this->globalRegion->addWrapperClass('showing-admin-menu');
            $this->globalRegion->addRegion(
                (new AdminMenuRegion([
                    (new HorizontalMenu($this->menu->getAllItemsAsMenu($this->currentUser, "administration")))
                        ->setID("TopBarAdminMenu")
                        ->addClass('col'),
                ]))->addWrapperClass('administration-menu')
            );
        }
        $this->globalRegion->addRegions([
            (new LeftSideBarRegion([
                (new ImageTile())
                    ->setID('TopBarImageTile')
                    ->setColWidth('xs', 12)
                    ->src(System::getVariable('generic_page_logo_url') ?? '/assets/logos/logo.svg'),
                (new AccountTile())
                    ->name($this->currentUser->getNiceName())->role($roleEntity->name ?? 'Logged in'),
                ...$this->leftSidebarRegionMenus(),
            ]))->clearWrapperClasses()->addWrapperClass('col col-3'),
        ]);

        $this->globalRegion->addRegions([
            (new ContentRegion([
                (new TopBarRegion([
                    (new RowWrapper())->resetColumns()->addClass('col')
                        ->addComponent($this->TitleTile->addClass('row')),
                    (new DropdownMenu())
                        ->addMenuByName("Account Menu")
                        ->addIcon("user-circle")
                        ->resetColumns()
                        ->addClass('col top-bar-user-menu')
                        ->addTitle($this->currentUser->getNiceName()),
                ]))->addWrapperClass('content-no-bg'),
            ]))->clearWrapperClasses()->addWrapperClass('col'),
        ]);
    }

    private function leftSidebarRegionMenus(): array
    {
        return Hook::processHook(genericPageLeftMenu::HOOK__MENUS, [
            (new MenuComponent())
                ->addMenuItems($this->menu->getAllItemsAsMenu($this->currentUser))
                ->title("Navigation"),
        ], $this->menu, $this->currentUser);
    }
}
