<?php

namespace apexl\Io\modules\display\controllers;

use apexl\Io\includes\Controller;
use apexl\Io\includes\Routes;
use apexl\Io\includes\System;
use apexl\Io\modules\display\components\ButtonBar;
use apexl\Io\modules\display\components\EntityFilteredDisplayTable;
use apexl\Io\modules\display\components\FormComponent;
use apexl\Io\modules\display\components\genericComponents;
use apexl\Io\modules\display\services\Render;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Http\Message\ServerRequestInterface as Request;

class displayController extends Controller
{
    /** @var Render  */
    protected $render;

    public function __construct(Render $render)
    {
        parent::__construct();
        $this->render = $render;
    }

    /**
     * @throws \Exception
     */
    public function all(Request $request, Response $response, $args = [])
    {
        try {
            $entity = $this->instantiateEntityFromRoute($request);
            $listTable = new EntityFilteredDisplayTable($entity);

            $buttonBar = (new ButtonBar())->setEntity($entity, "List");

            //render
            $this->render::setPageTitle($entity->getNiceName().' List');
            $this->output::addResponse($request, $this->render::build([$buttonBar, $listTable]));
            return System::asJson($response);
        } catch(\Exception $e) {
            $this->output::addMessage('basic.display.all', 'error', 'Fatal Error occurred: '.$e->getMessage());
        }
        return $this->throw404($response);
    }

    public function view(Request $request, Response $response, $args = [])
    {
        return System::asJson($response);
    }

    public function create(Request $request, Response $response, $args = [])
    {
        $entity = $this->instantiateEntityFromRoute($request);
        $title = 'Create new '.$entity->getNiceName();
        if ($id = $args['id'] ?? false) {
            $entity->load($id);
            $title = 'Update ' . $entity->getNiceName();
            $buttonBar = (new ButtonBar())->setEntity($entity, "Edit");
        } else {
            $buttonBar = (new ButtonBar())->setEntity($entity, "Create");
        }

        $form = (new FormComponent())
            ->setID($entity->getEntityName().'Create')
            ->src(Routes::getRoutePattern($entity->getEntityName().'.entity.form.createUpdate', $args));
        $this->render::setPageTitle($title);
        $this->output::addResponse($request, $this->render::build([genericComponents::dashboardBlockWrapper([$buttonBar, $form])]));
        return System::asJson($response);
    }

    public function delete(Request $request, Response $response, $args = [])
    {
        if ($id = $args['id'] ?? false) {
            $entity = $this->instantiateEntityFromRoute($request);
            $entity->load($id);
            //don't boolean check this, we want id 0 to fail (anon) so it can't be deleted.
            if ($entity->{$entity->primaryKey}) {
                //this is the form to LOAD via the src, not the form itself.
                $form = (new FormComponent())
                    ->src(Routes::getRoutePattern('form.universal.entity.delete', ['entity' => $entity->getEntityName(), 'id' => $id]))
                    ->title("Are you sure you want to delete this ".$entity->getEntityName().": ".$entity->getNiceName()."?")
                    ->header(3);
                $this->render::setPageTitle('Confirm deleting: '.$entity->getNiceName());
                $this->output::addResponse($request, $this->render::build([$form]));
                return System::asJson($response);
            }
            return $this->throw404($response);
        }
        return $this->throw404($response);
    }
}
