<?php

namespace apexl\Io\modules\display\controllers;

use apexl\Io\includes\Hook;
use apexl\Io\includes\System;
use apexl\Io\modules\display\services\Render;
use apexl\Io\modules\user\entities\userEntity;
use apexl\Io\modules\user\services\currentUser;
use Psr\Http\Message\ResponseInterface;
use Psr\Http\Message\ServerRequestInterface;

class dashboardController
{
    protected ?userEntity $currentUser;

    public function __construct(
        protected Render $render,
        currentUser $currentUser
    ) {
        $this->currentUser = $currentUser::getCurrentUser();
    }

    public function __invoke(ServerRequestInterface $request, ResponseInterface $response): ResponseInterface
    {
        /**
         * Allow modules to add things to the dashboard through hooks -
         * we need to have this route by default or nothing works!
         * @todo better routing overrides?
         */
        $components = Hook::processHook('genericWrapperAlter', [], 'DashboardHomeAlter');

        return System::asJson($response, $this->render::build($components));
    }
}
