<?php

namespace apexl\Io\modules\display\components;

use apexl\Io\modules\component\entities\componentEntity;

class NoUIWrapper extends componentEntity
{
    protected $wrapper;

    public function __construct()
    {
        parent::__construct();
        $this->setName("ComponentWrapper");
        $this->addClass('h-100')->addClass('page-no-layout');
        $this->wrapper = new RowWrapper();

        //rely on object inheritance to allow us to continue to manipulate the wrapper.
        $contentCentre = (new ComponentWrapper())
            ->addComponent($this->wrapper)
            ->addClass('row');

        $this->__addComponent($contentCentre);
    }

    /**
     * @param $component
     * @return $this
     */
    public function wrapperComponent($component)
    {
        $this->wrapper = $component;
        return $this;
    }

    /**
     * @param componentEntity $componentEntity
     * @return NoUIWrapper
     */
    public function addComponent(componentEntity $componentEntity)
    {
        $this->wrapper->addComponent($componentEntity);
        return $this;
    }

    /**
     * We need to maintain this functionality internally, but override it for the component.
     * @return NoUIWrapper
     */
    protected function __addComponent(componentEntity $componentEntity)
    {
        $this->components[$componentEntity->id] = $componentEntity;
        return $this;
    }
}
