<?php

namespace apexl\Io\modules\display\components\form;

use apexl\Io\modules\component\entities\componentEntity;

class DatePickerField extends InputField
{

    public function __construct($fieldName)
    {
        parent::__construct($fieldName);
        $this->minDate(date('Y/m/d'));
        $this->maxDate(date('Y/m/d', (strtotime('+ 3 years'))));
        $this->setName('DatePickerField');
        $this->setInputType('date');
    }
    
    public function setInputType(string $type)
    {
        $this->addProperty('inputType', $type);
        return $this;
    }

    public function setPlaceholder(string $text)
    {
        $this->addProperty('placeholder', $text);
        return $this;
    }

    public function minDate(string $min)
    {
        $this->addProperty('min', $min);
        return $this;
    }

    public function maxDate(string $max)
    {
        $this->addProperty('max', $max);
        return $this;
    }

}
