<?php

namespace apexl\Io\modules\display\components;

use apexl\Io\exceptions\RecordNotFoundException;
use apexl\Io\modules\component\entities\componentEntity;
use apexl\Io\modules\menu\entities\menuEntity;

class DropdownMenu extends componentEntity
{
    public function __construct()
    {
        parent::__construct();
        $this->setName('SimpleDropdownMenu');
    }

    public function addMenuByName($name): static
    {
        try {
            $menuEntity = new menuEntity();
            $menuEntity->loadByName($name);
            $this->addProperty('menuItems', $menuEntity->getAllItemsAsMenu($this->currentUser));
        } catch (RecordNotFoundException $exception) {
            logger('error')->warning('Menu {name} not found: {error}', [
                'name' => $name,
                'error' => $exception->getMessage(),
                'exception' => $exception,
            ]);
            $this->addProperty('menuItems', []);
        }

        return $this;
    }

    public function addMenuItems($items): static
    {
        $this->addProperty('menuItems', $items);

        return $this;
    }

    public function addTitle($title): static
    {
        $this->addProperty('menuTitle', $title);

        return $this;
    }

    public function addIcon($icon): static
    {
        $this->addProperty('menuIcon', $icon);

        return $this;
    }
}
