<?php
namespace apexl\Io\modules\display\components;

use apexl\Io\modules\component\entities\componentEntity;

class Chart extends componentEntity {
    public function __construct()
    {
        parent::__construct();
        $this->setChartType('Line');
    }

    public function setChartType($type){
        $this->addProperty('chartType', $type);
        return $this;
    }

    public function setChartData($data){
        $this->addProperty('chartData', $data);
        return $this;
    }

    public function setChartLabels($labels, $generateRandomColours=true) {
        $this->addProperty('chartLabels', $labels);
        if ($generateRandomColours) {
            $this->setChartColours($this->generateRandomColoursArray(count($labels)));
        }
        return $this;
    }

    public function setChartColours($colours) {
        $this->addProperty('chartColours', $colours);
        return $this;
    }

    protected function generateRandomColoursArray($length)
    {
        $colours = [];
        for ($i=0; $i<$length; $i++) {
            $colours[] = sprintf('#%06X', mt_rand(0, 0xFFFFFF));
        }

        return $colours;
    }
}