<?php

namespace apexl\Io\modules\display\pages;

use apexl\Io\includes\Hook;
use apexl\Io\includes\System;
use apexl\Io\modules\admin\enums\permissions\Admin;
use apexl\Io\modules\display\components\AccountTile;
use apexl\Io\modules\display\components\DropdownMenu;
use apexl\Io\modules\display\components\FilterableMenus;
use apexl\Io\modules\display\components\HorizontalMenu;
use apexl\Io\modules\display\components\ImageTile;
use apexl\Io\modules\display\components\Menu as MenuComponent;
use apexl\Io\modules\display\components\RowWrapper;
use apexl\Io\modules\display\components\TitleTile;
use apexl\Io\modules\display\includes\Page;
use apexl\Io\modules\display\regions\AdminMenuRegion;
use apexl\Io\modules\display\regions\ContentRegion;
use apexl\Io\modules\display\regions\LeftSideBarRegion;
use apexl\Io\modules\display\regions\PageContentRegion;
use apexl\Io\modules\display\regions\TopBarRegion;

class genericPageLeftMenu extends Page
{
    public const string HOOK__MENUS = 'genericPageLeftMenu.menus';
    public const string HOOK__MENUS_FILTERABLE = 'genericPageLeftMenu.menusFilterable';

    protected bool $hasImageTileInLeftSidebar = true;
    protected bool $hasAccountTileInLeftSidebar = true;

    /**
     * @param $component
     * @param null $weight
     */
    public function addToTopBar($component, $weight = null)
    {
        $this->addToRegion($component, "TopBarRegion", $weight);
    }

    /**
     * @param $component
     * @param null $weight
     */
    public function addToLeftSidebar($component, $weight = null)
    {
        $this->addToRegion($component, "LeftSideBarRegion", $weight);
    }

    /**
     * build the wrapper, specify some default "regions" that can be populated with components.
     *
     * Page structure by default looks like this:
     *  The page content
     *  |------------------------------------------------
     *  | The Top Menu bar
     *  | - Image region -- Menu region --
     *  |------------------------------------------------
     *  | - The Left Sidebar -- | Main content area
     *  |                       | Title Tile
     *  |                       | Main content
     *  | -----------------------------------------------
     *  | - The footer
     *  | -----------------------------------------------
     * @throws \Exception
     */
    protected function buildRegions()
    {
        $this->TitleTile = new TitleTile($this);
        $this->registerTitleComponent((new TitleTile($this))->addBreadcrumbs($this->menu->getMenu()));

        //reset the regions, we have only content as a default.
        $this->globalRegion = (new PageContentRegion())->addWrapperClass('page-left-menu row m-0');

        if ($this->currentUser->isAllowed(Admin::ADMINISTER) && (System::getVariable(
                'core_display_admin_menu'
            ) ?? true)) {
            $this->globalRegion->addWrapperClass('showing-admin-menu');
            $this->addAdminMenu();
        }

        $this->addLeftSidebarRegion();
        $this->addContentRegion();

    }

    protected function addAdminMenu(): void
    {
        $this->globalRegion->addRegion(
            (new AdminMenuRegion([
                (new HorizontalMenu($this->menu->getAllItemsAsMenu($this->currentUser, "administration")))
                    ->setID("TopBarAdminMenu")
                    ->addClass('col'),
            ]))->addWrapperClass('administration-menu')
        );

    }

    protected function addLeftSidebarRegion(): void
    {
        $components = [];
        if ($this->hasImageTileInLeftSidebar) {
            $components[] = (new ImageTile())
                ->setID('TopBarImageTile')
                ->setColWidth('xs', 12)
                ->src(System::getVariable('generic_page_logo_url') ?? '/assets/logos/logo.svg');
        }

        if ($this->hasAccountTileInLeftSidebar) {
            $components[] = (new AccountTile())
                ->name($this->currentUser->getNiceName());
        }

        $this->globalRegion->addRegions([
            new LeftSideBarRegion([
                ...$components,
                new FilterableMenus(
                    $this->leftSidebarRegionMenus(),
                    Hook::processHook(self::HOOK__MENUS_FILTERABLE, true)
                ),
            ])->clearWrapperClasses()->addWrapperClass('col col-3'),
        ]);
    }

    protected function leftSidebarRegionMenus(): array
    {
        return Hook::processHook(genericPageLeftMenu::HOOK__MENUS, [
            (new MenuComponent())
                ->addMenuItems($this->menu->getAllItemsAsMenu($this->currentUser))
                ->title("Navigation"),
        ], $this->menu, $this->currentUser);
    }

    protected function addContentRegion(): void
    {
        $this->globalRegion->addRegions([
            (new ContentRegion([
                (new TopBarRegion([
                    (new RowWrapper())->resetColumns()->addClass('col')
                        ->addComponent($this->TitleTile->addClass('row')),
                    (new DropdownMenu())
                        ->addMenuByName("Account Menu")
                        ->addIcon("user-circle")
                        ->resetColumns()
                        ->addClass('col top-bar-user-menu')
                        ->addTitle($this->currentUser->getNiceName()),
                ]))->addWrapperClass('content-no-bg'),
            ]))->clearWrapperClasses()->addWrapperClass('col'),
        ]);

    }
}
