<?php

namespace apexl\Io\modules\display\components;

use apexl\Io\includes\Entity;
use apexl\Io\includes\Routes;

class EntityFilteredDisplayTable extends EntityDisplayTable
{
    protected FilterForm $filterForm;

    public function __construct(Entity $entity = null, $replacements = [], $withButtons = true)
    {
        parent::__construct($entity, $replacements);
        if ($entity !== null) {
            $this->setFilters('orderBy[]='.$entity->primaryKey.'&orderBy[]=DESC');

            if ($withButtons) {
                $this->addCommonButtons();
            }
        }
    }

    public function addFilterForm($routeName, $title = null, $header = 5)
    {
        $this->filterForm = (new FilterForm())
            ->src(Routes::getRoutePattern($routeName))
            ->title($title)
            ->header($header);

        $this->addSupportComponent($this->filterForm);
    }
}
