<?php

namespace apexl\Io\modules\display;

use apexl\Io\includes\Hook;
use apexl\Io\interfaces\HasServicesInterface;
use apexl\Io\modules\display\callbacks\boot;
use apexl\Io\modules\display\callbacks\redirects;
use apexl\Io\modules\display\controllers\dashboardController;
use apexl\Io\modules\display\controllers\formsController;
use apexl\Io\modules\display\services\Render;
use apexl\Io\modules\user\classes\userManagedDisplayModule;

class displayModule extends userManagedDisplayModule implements HasServicesInterface
{
    public function __construct()
    {
        parent::__construct();
        $this->setBaseRoute('/display/v'.$this->apiVersion().'/universal');
    }

    public function routes(): void
    {
        //base pages
        $this->addProtectedRootRoute('GET', 'home', '/', dashboardController::class.':dashboard', 'IsLoggedIn');
        //base forms
        $this->addProtectedFormRoute(
            'form.universal.entity.delete',
            'entities/{entity}/{id}/delete',
            formsController::class.':entityDelete'
        );
    }

    public function addServices(): array
    {
        return [
            Render::class => function () {
                return Render::getInstance();
            },
        ];
    }

    public function registerCallbacks()
    {
        Hook::registerCallback('postAuth', boot::class.':display');
        Hook::registerCallback('addResponse', redirects::class.':redirects');
    }
}
