<?php

declare(strict_types=1);

namespace apexl\Io\modules\display\hooks;

use apexl\Io\hooks\AbstractHook;
use apexl\Io\includes\Entity;
use apexl\Io\includes\Routes;
use apexl\Io\services\Output;
use Psr\Http\Message\ResponseInterface;

readonly class redirectFollowingEntityDeleteHook extends AbstractHook
{
    static protected function hooks(): array
    {
        return [
            'addResponse',
        ];
    }

    public function __invoke(ResponseInterface $response, string $route, Output $output): void
    {
        if (strpos($route, 'Entity.delete')) {
            $entity = $output::getMetadata('core.controller.delete.entityType')['entityType'] ?? false;
            $entityId = $output::getMetadata('core.controller.delete.entityId')['entityId'] ?? false;

            if ($entity && $entityId) {
                /** @var Entity $instantEntity */
                $instantEntity = new $entity();
                $output::addMetadata(
                    sprintf('%s.delete.redirect', $instantEntity->getEntityName()),
                    'redirect',
                    Routes::getRoutePattern(
                        sprintf('%s.display.all', $instantEntity->getEntityName())
                    )
                );
            }
        }
    }
}
