<?php

namespace apexl\Io\modules\display\pages;

use apexl\Io\includes\System;
use apexl\Io\modules\display\components\AccountTile;
use apexl\Io\modules\display\components\DropdownMenu;
use apexl\Io\modules\display\components\HorizontalMenu;
use apexl\Io\modules\display\components\ImageTile;
use apexl\Io\modules\display\components\RowWrapper;
use apexl\Io\modules\display\components\TheTopMenuBar;
use apexl\Io\modules\display\components\TitleTile;
use apexl\Io\modules\display\regions\ContentRegion;
use apexl\Io\modules\display\regions\LeftSideBarRegion;
use apexl\Io\modules\display\regions\PageContentRegion;
use apexl\Io\modules\display\regions\TopBarRegion;
use apexl\Io\modules\display\components\Menu as MenuComponent;
use apexl\Io\modules\display\includes\Page;
use apexl\Io\modules\user\entities\roleEntity;

class genericPageTopBar extends Page
{
    /**
     * build the wrapper, specify some default "regions" that can be populated with components.
     *
     * Page structure by default looks like this:
     *  The page content
     *  |------------------------------------------------
     *  | The Top Menu bar
     *  | - Image region -- Menu region --
     *  |------------------------------------------------
     *  | | Main content area
     *  | -----------------------------------------------
     *  | - The footer
     *  | -----------------------------------------------
     * @throws \Exception
     */
    protected function buildRegions()
    {
        $this->registerTitleComponent((new TitleTile($this))->addBreadcrumbs($this->menu->getMenu()));
        //reset the regions, we have only content as a default.
        $this->globalRegion = (new PageContentRegion())->addWrapperClass('page-top-menu');
        $this->globalRegion->addRegions([
            (new TopBarRegion([(new TheTopMenuBar())->addComponent(
                (new ImageTile())->src(System::getVariable('generic_page_logo_url') ?? '/assets/logos/logo.svg')
            )]))->clearWrapperClasses(),
            (new ContentRegion())->addSecondaryComponent(
                (new RowWrapper())->addComponent(
                    (new HorizontalMenu($this->menu->getAllItemsAsMenu($this->currentUser)))->setID("MainMenu")->addClass('col')
                )
            )->clearWrapperClasses()
        ]);
    }

    /**
     * @param $component
     * @param null $weight
     */
    public function addToTopBar($component, $weight = null)
    {
        $this->addToRegion($component, "TopBarRegion", $weight);
    }

    /**
     * @param $component
     * @param null $weight
     */
    public function addToLeftSidebar($component, $weight = null)
    {
        $this->addToRegion($component, "LeftSideBarRegion", $weight);
    }
}
