<?php

namespace apexl\Io\modules\display;

use apexl\Io\interfaces\HasServicesInterface;
use apexl\Io\modules\display\controllers\dashboardController;
use apexl\Io\modules\display\controllers\formsController;
use apexl\Io\modules\display\hooks\redirectFollowingEntityDeleteHook;
use apexl\Io\modules\display\hooks\setDefaultRenderDisplaysHook;
use apexl\Io\modules\display\services\Render;
use apexl\Io\modules\user\classes\userManagedDisplayModule;
use app\vendor\apexl\io\src\Io\interfaces\HasHooksInterface;

class displayModule extends userManagedDisplayModule implements HasServicesInterface, HasHooksInterface
{
    public function __construct()
    {
        parent::__construct();
        $this->setBaseRoute(sprintf('/display/v%s/universal', $this->apiVersion()));
    }

    public function routes(): void
    {
        //base pages
        $this->addProtectedRootRoute(
            'GET',
            'home',
            '/',
            dashboardController::class,
            'IsLoggedIn'
        );
        //base forms
        $this->addProtectedFormRoute(
            'form.universal.entity.delete',
            'entities/{entity}/{id}/delete',
            [formsController::class, 'entityDelete'],
        );
    }

    public function addServices(): array
    {
        return [
            Render::class => function () {
                return Render::getInstance();
            },
        ];
    }

    public function hooks(): array
    {
        return [
            setDefaultRenderDisplaysHook::class,
            redirectFollowingEntityDeleteHook::class,
        ];
    }
}
