<?php

declare(strict_types=1);

namespace apexl\Io\modules\display\hooks;

use apexl\Io\hooks\AbstractHook;
use apexl\Io\modules\display\pages\blankPage;
use apexl\Io\modules\display\pages\genericPageLeftMenu;
use apexl\Io\modules\display\pages\noUIiframeFlow;
use apexl\Io\modules\display\services\Render;

final readonly class setDefaultRenderDisplaysHook extends AbstractHook
{

    static protected function hooks(): array
    {
        return ['postAuth'];
    }

    public function __invoke(): void
    {
        //only apply a default if it hasn't already been done.
        if (!Render::getPage('default')) {
            Render::registerDefault(genericPageLeftMenu::getInstance());
        }
        if (!Render::getPage('noUI')) {
            Render::registerPage('noUI', blankPage::getInstance());
        }
        if (!Render::getPage('noUIiframe')) {
            Render::registerPage('noUIiframe', noUIiframeFlow::getInstance());
        }
    }

}
