<?php

namespace apexl\Io\modules\display\components;

use apexl\Io\modules\component\entities\componentEntity;
use apexl\Io\modules\menu\entities\menuEntity;

class DropMenu extends componentEntity
{
    protected $items = [];

    public function __construct()
    {
        parent::__construct();
        $this->setName('DropMenu');
    }

    public function addMenuItems($items, $add=true)
    {
        if ($add && count($this->items) > 0) {
            $this->items = array_merge($this->items, $items);
        } else {
            $this->items = $items;
        }

        $this->addProperty('items', $this->items);
        $this->addClass('dropmenu-items-'.count($this->items));
        return $this;
    }

}
