<?php

namespace apexl\Io\modules\display\components;

use apexl\Config\Singleton;
use apexl\Io\includes\RouteManager;
use apexl\Io\modules\component\entities\componentEntity;

class MessageList extends componentEntity
{

    public function __construct($messages)
    {
        parent::__construct();
        $this->setItems($messages);
    }

    public function setItems($messages)
    {
        $this->addProperty('messages', $messages);
        return $this;
    }

    public function addConfirmButton($route, $text, $class = "")
    {
        if ($url = $this->routeManager->getRoutePattern($route)) {
            $this->addProperty('confirmButtonUrl', (Singleton::getInstance())->app->site->backend_domain . $url);
            $this->addProperty('confirmButtonText', $text);
            if ($class) $this->addProperty('confirmButtonClass', $class);
        }

        return $this;
    }


}
