<?php

namespace apexl\Io\modules\display\components;

use apexl\Io\modules\component\entities\componentEntity;

class NoUIWrapper extends componentEntity
{
    protected RowWrapper $wrapper;

    public function __construct()
    {
        parent::__construct();
        $this->setName("ComponentWrapper");
        $this->addClass('h-100')
            ->addClass('page-no-layout');

        $this->wrapper = new RowWrapper();

        //rely on object inheritance to allow us to continue to manipulate the wrapper.
        $contentCentre = (new ComponentWrapper())
            ->addComponent($this->wrapper)
            ->addClass('row');

        $this->__addComponent($contentCentre);
    }

    public function addComponent(componentEntity $componentEntity): static
    {
        $this->wrapper->addComponent($componentEntity);

        return $this;
    }

    /**
     * We need to maintain this functionality internally, but override it for the component.
     */
    protected function __addComponent(componentEntity $componentEntity): static
    {
        $this->components->set($componentEntity->id, $componentEntity);

        return $this;
    }
}
