<?php

namespace apexl\Io\modules\display\components\form;

use apexl\Io\modules\component\entities\componentEntity;

class Form extends componentEntity
{
    protected $fieldsets = [];
    protected $formGroups = [];

    public function __construct()
    {
        parent::__construct();
        $this->header(5);
        $this->setName('Form');
        $this->addProperty('id', $this->id);
    }

    public function addComponent(componentEntity $componentEntity): static
    {
        if (method_exists($componentEntity, 'setFormId')) {
            $componentEntity->setFormId($this->id);
        }
        parent::addComponent($componentEntity);

        return $this;
    }

    public function setID($id): static
    {
        $this->data['id'] = $id;
        $this->addProperty('id', $this->id);

        return $this;
    }
    
    public function setActionUrl(string $url)
    {
        $this->addProperty('action', $url);
        return $this;
    }

    public function setMethod(string $method)
    {
        $this->addProperty('method', strtoupper($method));
        return $this;
    }

    public function setSubmitText(string $text)
    {
        $this->addProperty('submitText', $text);
        return $this;
    }

    public function removeSubmitButton(bool $state): static
    {
        $this->addProperty('removeSubmit', $state);
        return $this;
    }

    public function header($num)
    {
        $this->addProperty('header', $num);
        return $this;
    }

    public function title($title)
    {
        if ($title) {
            $this->addProperty('title', $title);
        }
        return $this;
    }

    public function includeClearButton()
    {
        $this->addProperty('includeClearButton', true);
        return $this;
    }

    public function setClearButtonText(string $text)
    {
        if ($text) {
            $this->addProperty('clearButtonText', $text);
        }
        return $this;
    }

    public function addField(componentEntity $field, $fieldsetName=null)
    {
        if ($fieldsetName && isset($this->fieldsets[$fieldsetName])) {
            $this->fieldsets[$fieldsetName]->addComponent($field);
        } else {
            $this->addComponent($field);
        }
        return $this;
    }

    public function removeFieldset(string $name): Form
    {
        if (isset($this->fieldsets[$name])) {
            unset($this->fieldsets[$name]);
        }

        return $this;
    }

    public function setFieldsetSetting($fieldsetName, $dummy, $legend) // Note $dummy is here for backwards compatibility reasons, to save a lot of code edits being required upgrading v1 -> v2
    {
        if (!isset($this->fieldsets[$fieldsetName])) {
            $fieldset = new Fieldset();
            $fieldset->legend($legend);
            $this->fieldsets[$fieldsetName] = $fieldset;
            $this->addComponent($fieldset);
        }
        return $this;
    }

    public function addFieldToGroup(componentEntity $field, $groupName, $fieldsetName=null)
    {
        ($this->getGroup($groupName, $fieldsetName))->addComponent($field);
    }

    protected function getGroup($groupName, $fieldsetName)
    {
        if (!isset($this->formGroups[$groupName])) {
            $this->formGroups[$groupName] = (new FormGroup());
            if ($fieldsetName) {
                ($this->fieldsets[$fieldsetName])->addComponent($this->formGroups[$groupName]);
            } else {
                $this->addComponent($this->formGroups[$groupName]);
            }
        }

        return $this->formGroups[$groupName];
    }

    
}
