<?php

namespace apexl\Io\modules\display\components\form;

use apexl\Io\modules\component\entities\componentEntity;

class RadioGroupField extends BaseField
{
    
    public function __construct($fieldName, $options = [])
    {
        parent::__construct($fieldName);
        $this->setName('RadioGroupField');
        $this->setFieldName($fieldName);
        $this->addOptions($options);
    }

    public function setPlaceholder(string $text)
    {
        $this->addProperty('placeholder', $text);
        return $this;
    }

    public function addOptions(array $options)
    {
        if (is_array($options)) {
            $newOptions = [];
            foreach ($options as $key => $value) {
                $newOptions[] = (object)["key" => $key, "value" => $value];
            }
            $options = $newOptions;
            $this->addProperty('options', $options);
        }

        return $this;
    }

    public function buildOptionsFromEntities($entities, $key, $value)
    {
        $options = [];
        foreach ($entities as $entity) {
            $options[$entity->$key] = $entity->$value;
        }
        $this->addOptions($options);
        return $this;
    }


}
