<?php

declare(strict_types=1);

namespace apexl\Io\modules\display\hooks;

use apexl\Io\interfaces\AbstractHook;
use apexl\Io\modules\display\pages\blankPage;
use apexl\Io\modules\display\pages\genericPageLeftMenu;
use apexl\Io\modules\display\pages\noUIiframeFlow;
use apexl\Io\modules\display\services\Render;

final readonly class setDefaultRenderDisplaysHook implements AbstractHook
{
    public function hooks(): array
    {
        return ['postAuth'];
    }

    public function __invoke(
        int $userId,
        Render $render,
        genericPageLeftMenu $genericPageLeftMenu,
        blankPage $blankPage,
        noUIiframeFlow $noUIiframeFlow,
    ): void {
        //only apply a default if it hasn't already been done.
        if (!$render->getPage('default')) {
            $render->registerDefault($genericPageLeftMenu);
        }
        if (!$render->getPage('noUI')) {
            $render->registerPage('noUI', $blankPage);
        }
        if (!$render->getPage('noUIiframe')) {
            $render->registerPage('noUIiframe', $noUIiframeFlow);
        }
    }

}
