<?php

declare(strict_types=1);

namespace apexl\Io\modules\display\services;

use apexl\Io\modules\display\interfaces\ComponentInterface;
use DI\Container;

final readonly class ComponentFactory
{
    public function __construct(private Container $container) {}

    /**
     * @var class-string<ComponentInterface> $class
     */
    public function make(string $class, array $params = []): ComponentInterface
    {
        assert(is_a($class, ComponentInterface::class, true));

        $component = $this->container->make($class);
        $component->init(...$params);

        return $component;
    }
}