<?php

namespace apexl\Io\modules\display\components\form;

use apexl\entityCore\interfaces\entityInterface;

class EntityForm extends Form
{
    protected $fieldsets = [];
    protected $formGroups = [];

    public function __construct($entity, $args, $omitColumns = [])
    {
        parent::__construct();
        $this->header(5);
        $this->setName('Form');
        $this->addProperty('id', $this->id);
        $this->initiate($entity, $args, $omitColumns);
    }

    public function initiate($entity, $args, $omitColumns = [])
    {
        $action = 'post';
        if ($id = $args[$entity->primaryKey] ?? false) {
            $entity->load($id);
            //append the ID to the URL, make sure we're consistent so strip any trailing slashes
            $action = 'put';
        }

        $replacements = [];
        if ($entity->id ?? false) {
            $replacements[$entity->primaryKey] = $entity->{$entity->primaryKey};
        }

        $this->setId('entityForm-' . $entity->getEntityName());
        $this->setMethod($action);
        $this->setActionUrl(
            $this->routeManager->getRoutePattern($entity->getEntityName() . '.' . $action, $replacements)
        );
        $this->addClass('entityForm')->addClass($entity->getEntityName());

        //construct fields
        $fields = [];
        if ($entity->extends && isset($entity->extends->entity)) { // If entity is an extension, add fields of parent
            $parentEntityName = $entity->extends->entity;
            $parentEntity = new $parentEntityName();
            $fields = array_merge($fields, self::entityFormFields($parentEntity, $entity, $omitColumns));
        }
        $fields = array_merge($fields, self::entityFormFields($entity, null, $omitColumns));
        $fields = array_filter($fields);
        foreach ($fields as $field) {
            $this->addField($field);
        }
    }


    protected static function entityFormFields(EntityInterface $entity, $childEntity = null, $omitColumns = [])
    {
        $fields = [];
        $entityFields = $entity->getTableColumns();
        foreach ($entityFields as $entityField) {
            //skip the primary key field
            if ($entityField->Field == $entity->primaryKey || in_array($entityField->Field, $omitColumns)) {
                continue;
            }
            //first, split the type into type and length
            $type = $entityField->Type;
            $length = null;
            if (strpos((string) $type, '(')) {
                //i dont like regex, so we're going to cheat. @todo - actually to this with regex
                $parts = explode('(', (string) $type);
                //take the first part as the type
                $type = array_shift($parts);
                //take the second part as the length, strip the end bracket.
                $length = str_replace(')', '', array_shift($parts));
            }
            //don't include any create or modified fields.
            if (in_array($entityField->Field, ["created", "created_by", "modified", "modified_by"])) {
                continue;
            }

            $childEntity = $childEntity ? $childEntity : $entity;
            $fieldConfig = $childEntity->getFieldConfig();

            $fields[$entityField->Field] = self::fieldByType(
                $entityField->Field,
                $type,
                $length,
                $childEntity,
                $fieldConfig
            );
        }

        return $fields;
    }

    protected static function fieldByType($name, $type, $length, $entity, $fieldConfig, $disabled = false)
    {
        $field = null;
        //allow entity config to override field types.
        if (isset($fieldConfig[$name]) && isset($fieldConfig[$name]['formField'])) {
            $field = $fieldConfig[$name]['formField']($entity);
        } else {
            switch ($type) {
                //not a boolean field? cascade into varchar
                case "int":
                    $field = (new NumberField($name))->setLabel($entity->hrName($name))->addClass($name)->setLength(
                        $length
                    )->setValue(0);
                    break;
                case "varchar":
                    $field = (new InputField($name))->setLabel($entity->hrName($name))->addClass($name)->setLength(
                        $length
                    );
                    break;
                case "text":
                    $field = (new TextareaField($name))->setLabel($entity->hrName($name))->addClass($name);
                    break;
                case 'tinyint':
                case "bool":
                    $field = (new CheckboxField($name))->addClass($entity->hrName($name))->setLabel($name)->setLength(
                        $length
                    );
                    break;
            }
        }
        if ($field && ($value = $entity->{$name} ?? false)) {
            if ($type === 'int' && !is_numeric($value)) {
                $value = 0;
            }
            $field->setValue($value);
        }
        if ($disabled) {
            $field->isDisabled();
        }
        return $field;
    }


}
