<?php

declare(strict_types=1);

namespace apexl\Io\modules\display\components;

use apexl\Io\modules\component\entities\componentEntity;

final class FilterableMenus extends componentEntity
{
    private const string PROP__MENUS = 'menus';
    private const string PROP__FILTERABLE = 'filterable';
    
    public function setMenus(array $menus): FilterableMenus
    {
        return $this->addProperty(self::PROP__MENUS, $menus);
    }

    public function setFilterable(bool $filterable): FilterableMenus
    {
        return $this->addProperty(self::PROP__FILTERABLE, $filterable);
    }
}