<?php

declare(strict_types=1);

namespace apexl\Io\modules\display\Collections;

use apexl\Io\modules\display\includes\Page;
use Arrayy\Type\StringCollection;
use DI\Container;

final readonly class PageRegistry
{
    private StringCollection $pages;

    public function __construct(private Container $container)
    {
        $this->pages = new StringCollection();
    }

    public function has($key): bool
    {
        return $this->pages->has($key);
    }

    public function set(string $key, string $page): void
    {
        assert(is_a($page, Page::class, true));

        $this->pages->set($key, $page);
    }

    public function get($key)
    {
        $class = $this->pages->get($key);

        return $this->container->get($class);
    }

}
