<?php

declare(strict_types=1);

namespace apexl\Io\modules\display\ComponentFactory;

use apexl\Io\modules\component\Factories\GenericComponentFactory;
use apexl\Io\modules\display\components\form\Form;

final readonly class FormComponentFactory
{
    public function __construct(private GenericComponentFactory $componentFactory) {}

    /** @var class-string<Form> $class */
    public function make(string $class = Form::class): Form
    {
        assert(
            is_a($class, Form::class, true),
            sprintf('`%s` must be an instance of `%s`', self::class, Form::class)
        );

        /** @var Form $form */
        $form = $this->componentFactory->make($class);

        $form->init();

        return $form;
    }
}