<?php

namespace apexl\Io\modules\display\components;

use apexl\Io\modules\component\Collections\ComponentCollection;
use apexl\Io\modules\component\Collections\ComponentPropertyCollection;
use apexl\Io\modules\component\entities\componentEntity;
use apexl\Io\modules\component\Factories\ComponentPropertyFactory;
use apexl\Io\modules\display\includes\Page;
use apexl\Io\modules\menu\entities\menuEntity;
use apexl\Io\modules\menu\services\MenuManager;
use apexl\Io\services\HttpPaths;
use Arrayy\Type\StringCollection;

class TitleTile extends componentEntity
{
    protected string $title;

    public function __construct(
        private readonly HttpPaths $path,
        private readonly MenuManager $menu,
        ComponentPropertyFactory $propertyFactory,
        ComponentPropertyCollection $props,
        ComponentCollection $components,
        StringCollection $classes,

    ) {
        parent::__construct($propertyFactory, $props, $components, $classes);
    }

    public function addBreadcrumbs(menuEntity $menu): static
    {
        $this->addProperty('breadcrumbs', $menu->generateBreadcrumbs($this->path->getPath()));

        return $this;
    }

    public function __toString(): string
    {
        //we're outputting so check the final title values
        $titleRoute = $this->menu->getMenuItem($this->path->getPath());
        $this->text($this->title ?? $titleRoute->title ?? '');

        return parent::__toString();
    }

    /**
     * @param $text
     * @return $this
     */
    public function text($text): static
    {
        $this->addProperty('title', ucfirst(($text) ?? ""));

        return $this;
    }

    public function init(?Page $page = null): void
    {
        $this->addClass('col-sm-12');
        $this->headerSize(1);

        //set a reference so we can track page title changes.
        if ($page !== null) {
            $this->text($page->pageTitle);
        }
    }

    /**
     * @param $size
     * @return $this
     */
    public function headerSize($size): static
    {
        $this->addProperty('header', $size);

        return $this;
    }
}
