<?php

namespace apexl\Io\modules\display\components\form;

use apexl\Io\modules\component\entities\componentEntity;

class Form extends componentEntity
{
    public string $name = 'Form';
    protected $fieldsets = [];
    protected $formGroups = [];

    public function init(): void
    {
        $this->header(5);
        $this->addProperty('id', $this->id);
    }

    public function header($num): static
    {
        $this->addProperty('header', $num);
        return $this;
    }

    public function setId($id): static
    {
        $this->data['id'] = $id;
        $this->addProperty('id', $this->id);

        return $this;
    }

    public function setActionUrl(string $url): static
    {
        $this->addProperty('action', $url);
        return $this;
    }

    public function setMethod(string $method): static
    {
        $this->addProperty('method', strtoupper($method));
        return $this;
    }

    public function setSubmitText(string $text): static
    {
        $this->addProperty('submitText', $text);
        return $this;
    }

    public function removeSubmitButton(bool $state): static
    {
        $this->addProperty('removeSubmit', $state);
        return $this;
    }

    public function title($title): static
    {
        if ($title) {
            $this->addProperty('title', $title);
        }
        return $this;
    }

    public function includeClearButton(): static
    {
        $this->addProperty('includeClearButton', true);
        return $this;
    }

    public function setClearButtonText(string $text): static
    {
        if ($text) {
            $this->addProperty('clearButtonText', $text);
        }
        return $this;
    }

    public function addField(componentEntity $field, $fieldsetName = null): static
    {
        if ($fieldsetName && isset($this->fieldsets[$fieldsetName])) {
            $this->fieldsets[$fieldsetName]->addComponent($field);
        } else {
            $this->addComponent($field);
        }
        return $this;
    }

    public function addComponent(componentEntity $componentEntity): static
    {
        if (method_exists($componentEntity, 'setFormId')) {
            $componentEntity->setFormId($this->id);
        }
        parent::addComponent($componentEntity);

        return $this;
    }

    public function removeFieldset(string $name): Form
    {
        if (isset($this->fieldsets[$name])) {
            unset($this->fieldsets[$name]);
        }

        return $this;
    }

    public function setFieldsetSetting($fieldsetName, $dummy, $legend): static // Note $dummy is here for backwards compatibility reasons, to save a lot of code edits being required upgrading v1 -> v2
    {
        if (!isset($this->fieldsets[$fieldsetName])) {
            $fieldset = new Fieldset();
            $fieldset->legend($legend);
            $this->fieldsets[$fieldsetName] = $fieldset;
            $this->addComponent($fieldset);
        }
        return $this;
    }

    public function addFieldToGroup(componentEntity $field, $groupName, $fieldsetName = null): void
    {
        ($this->getGroup($groupName, $fieldsetName))->addComponent($field);
    }

    protected function getGroup($groupName, $fieldsetName): FormGroup
    {
        if (!isset($this->formGroups[$groupName])) {
            $this->formGroups[$groupName] = (new FormGroup());
            if ($fieldsetName) {
                ($this->fieldsets[$fieldsetName])->addComponent($this->formGroups[$groupName]);
            } else {
                $this->addComponent($this->formGroups[$groupName]);
            }
        }

        return $this->formGroups[$groupName];
    }


}
