<?php

declare(strict_types=1);

namespace apexl\Io\modules\display\ComponentFactory;

use apexl\Io\modules\component\Factories\GenericComponentFactory;
use apexl\Io\modules\display\components\form\BaseField;

final readonly class FormFieldComponentFactory
{
    public function __construct(
        private GenericComponentFactory $componentFactory,
    ) {}

    /**
     * @param class-string<BaseField> $class
     */
    public function make(string $class, string $fieldName): BaseField
    {
        assert(
            is_a($class, BaseField::class, true),
            sprintf('`%s` must be instanceof `%s`', $class, BaseField::class)
        );

        /** @var BaseField $field */
        $field = $this->componentFactory->make($class);

        $field->setFieldName($fieldName);;

        return $field;
    }
}