<?php

namespace apexl\Io\modules\display\controllers;

use apexl\Io\includes\Controller;
use apexl\Io\includes\HookManager;
use apexl\Io\modules\display\services\Render;
use Psr\Http\Message\ResponseInterface;
use Psr\Http\Message\ServerRequestInterface;

final readonly class dashboardController extends Controller
{
    public function __invoke(Render $render, HookManager $hookManager, ServerRequestInterface $request, ResponseInterface $response): ResponseInterface
    {
        /**
         * Allow modules to add things to the dashboard through hooks -
         * we need to have this route by default or nothing works!
         * @todo better routing overrides?
         */
        $components = $hookManager->processHook('genericWrapperAlter', [], 'DashboardHomeAlter');

        return $this->json($response, $render->build($components));
    }
}
