<?php

namespace apexl\Io\modules\display\components;

use apexl\Io\modules\component\entities\componentEntity;

class ContentTitle extends componentEntity
{
    public function init(?string $title = null, ?string $content = null, ?int $headerNum = null)
    {
        if ($title) {
            $this->addTitle($title);
        }

        if ($content) {
            $this->addContent($content);
        }

        $this->addHeader($headerNum ?? 3);
    }

    public function addTitle($text): ContentTitle
    {
        $this->addProperty('title', $text);

        return $this;
    }

    public function addContent($text): ContentTitle
    {
        $this->addProperty('content', $text);

        return $this;
    }

    public function addHeader($num): ContentTitle
    {
        $this->addProperty('header', $num);

        return $this;
    }
}
