<?php

namespace apexl\Io\modules\display\components;

use apexl\Io\exceptions\RecordNotFoundException;
use apexl\Io\modules\component\Collections\ComponentCollection;
use apexl\Io\modules\component\Collections\ComponentPropertyCollection;
use apexl\Io\modules\component\Factories\ComponentPropertyFactory;
use apexl\Io\modules\menu\entities\menuEntity;
use apexl\Io\modules\user\services\CurrentUserFactory;
use Arrayy\Type\StringCollection;

class DropdownMenu extends Menu
{
    public string $name = 'SimpleDropdownMenu';

    public function __construct(
        ComponentPropertyFactory $propertyFactory,
        ComponentPropertyCollection $props,
        ComponentCollection $components,
        StringCollection $classes,
        private readonly CurrentUserFactory $currentUserFactory
    ) {
        parent::__construct($propertyFactory, $props, $components, $classes);
    }

    public function addMenuByName($name): static
    {
        try {
            $menuEntity = menuEntity::from('name', $name);
            $this->addMenuItems($menuEntity->getAllItemsAsMenu($this->currentUserFactory->get()));
        } catch (RecordNotFoundException $exception) {
            logger('error')->warning('Menu {name} not found: {error}', [
                'name' => $name,
                'error' => $exception->getMessage(),
                'exception' => $exception,
            ]);
        }

        return $this;
    }

    public function addIcon($icon): static
    {
        $this->addProperty('menuIcon', $icon);

        return $this;
    }
}
