<?php

namespace apexl\Io\modules\display\components;

use apexl\Io\modules\component\entities\componentEntity;

class ImageTile extends componentEntity
{
    private const PROP__TITLE = 'title';
    private const PROP__SRC = 'imgSrc';
    private const PROP__HREF = 'href';
    
    public function title(string $title): ImageTile
    {
        $this->addProperty(self::PROP__TITLE, $title);

        return $this;
    }

    public function src($imgSrc): ImageTile
    {
        $this->addProperty(self::PROP__SRC, $imgSrc);

        return $this;
    }

    public function route($route): ImageTile
    {
        $this->addProperty(self::PROP__HREF, $route);

        return $this;
    }
}
