<?php

namespace apexl\Io\modules\display\components;

use apexl\Config\Singleton;
use apexl\Io\includes\RouteManager;
use apexl\Io\modules\component\entities\componentEntity;

class MessageList extends componentEntity
{
    public function __construct(private readonly RouteManager $routeManager) {}

    public function setItems($messages): static
    {
        $this->addProperty('messages', $messages);

        return $this;
    }

    public function addConfirmButton($route, $text, $class = ""): static
    {
        if ($url = $this->routeManager->getRoutePattern($route)) {
            $this->addProperty(
                'confirmButtonUrl',
                sprintf('%s%s', config('app.site.backend_domain'), $url)
            );
            $this->addProperty('confirmButtonText', $text);
            if ($class) $this->addProperty('confirmButtonClass', $class);
        }

        return $this;
    }


}
