<?php

declare(strict_types=1);

namespace apexl\Io\modules\display\ComponentFactory;

use apexl\Io\modules\component\Factories\GenericComponentFactory;
use apexl\Io\modules\display\components\FilterableMenus;

final readonly class FilterableMenusComponentFactory
{
    public function __construct(private GenericComponentFactory $componentFactory) {}

    public function make(array $menus, bool $filterable = false): FilterableMenus
    {
        return $this->componentFactory->make(FilterableMenus::class)
            ->setMenus($menus)
            ->setFilterable($filterable);
    }
}