<?php

namespace apexl\Io\modules\display\components;

use apexl\Io\includes\Entity;
use apexl\Io\modules\component\entities\componentEntity;

class EntityDisplayTile extends componentEntity
{
    protected $entity;

    protected $componentWrapper;
    protected $footer;
    protected $table;

    protected $enableView = true;
    protected $enableEdit = true;
    protected $enableDelete = true;


    public function __construct(Entity $entity)
    {
        parent::__construct();
        $this->name = 'rowWrapper';
        $this->addClass('data-tile col-lg-12 col-xl-6');

        $this->componentWrapper = (new RowWrapper())->resetClasses()->addClass('content-wrapper');
        $this->addClass($entity->getEntityTrueName() . '__tile-display');
        $this->entity = $entity;
        $this->addComponent($this->componentWrapper);
    }

    public function addContentTitle($title, $content = '', $header = 3)
    {
        $contentTitle = (new ContentTitle())->addTitle($title)->addContent($content)->addHeader($header);
        $this->componentWrapper->addComponent($contentTitle);
        return $this;
    }

    public function addCustomTable(EntityDisplayTable $table)
    {
        $this->table = $table;
        $this->componentWrapper->addComponent($this->table);
        return $this;
    }

    public function addTable($filters = null, $pagination = false, $dataSrc = null, $viewButton = true, $editButton = true, $deleteButton = true)
    {
        $this->table = (new EntityDisplayTable($this->entity))->addClass('w-100');
        $this->table->displayPagination($pagination);
        $this->table->displayShortTotals();
        if ($dataSrc) {
            $this->table->src($this->routeManager->getRoutePattern($dataSrc));
        }
        if ($filters) {
            $this->table->setFilters($filters);
        }

        if ($viewButton) {
            $this->table->addViewButton($this->entity->getEntityName() . '.display.get', !(bool) $this->enableView);
        }
        if ($editButton) {
            $this->table->addEditButton($this->entity->getEntityName() . '.display.put', !(bool) $this->enableEdit);
        }
        if ($deleteButton) {
            $this->table->addDeleteButton(
                $this->entity->getEntityName() . '.display.delete',
                !(bool) $this->enableDelete
            );
        }

        $this->componentWrapper->addComponent($this->table);
        return $this;
    }

    public function hideDisabledButtons($value = true)
    {
        $this->table->hideDisabled($value);
        return $this;
    }

    public function addButtonFooter(array $routes)
    {
        $footer = (new RowWrapper())->addClass('tile-footer');
        foreach ($routes as $route => $title) {
            $footer->addComponent(
                (new SimpleButton())->addRoute($this->routeManager->getRoutePattern($route))->addText($title)
            );
        }
        $this->componentWrapper->addComponent($footer);
        return $this;
    }
}
